/*
 * Decompiled with CFR 0.152.
 */
package com.song.castle_in_the_sky.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.song.castle_in_the_sky.config.ConfigCommon;
import com.song.castle_in_the_sky.features.CastleStructure;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class StructureRegister {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"castle_in_the_sky");
    public static final CastleStructure CASTLE_IN_THE_SKY_RAW = new CastleStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static final RegistryObject<Structure<NoFeatureConfig>> CASTLE_IN_THE_SKY = STRUCTURES.register("castle_in_the_sky", () -> CASTLE_IN_THE_SKY_RAW);

    public static void setupStructures() {
        StructureRegister.setupMapSpacingAndLand((Structure)CASTLE_IN_THE_SKY.get(), new StructureSeparationSettings(((Integer)ConfigCommon.CASTLE_AVG_DIST_CHUNK.get()).intValue(), ((Integer)ConfigCommon.CASTLE_MIN_DIST_CHUNK.get()).intValue(), 1234567890), false);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }

    static {
        Structure.field_236365_a_.put((Object)"castle_in_the_sky:castle_in_the_sky".toLowerCase(Locale.ROOT), (Object)CASTLE_IN_THE_SKY_RAW);
    }
}

